/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.infernomobs.model;

import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.model.ModelCustomObj;
import com.lycanitesmobs.infernomobs.InfernoMobs;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelSalamander
extends ModelCustomObj {
    float maxLeg = 0.0f;

    public ModelSalamander() {
        this(1.0f);
    }

    public ModelSalamander(float shadowSize) {
        this.initModel("salamander", InfernoMobs.group, "entity/salamander");
        this.setPartCenter("head", 0.0f, 0.497f, 0.9f);
        this.setPartCenter("body", 0.0f, 0.53f, 0.0f);
        this.setPartCenter("legleftfront", 0.5f, 0.6f, 0.4f);
        this.setPartCenter("legrightfront", -0.5f, 0.6f, 0.4f);
        this.setPartCenter("legleftback", 0.4f, 0.6f, -1.1f);
        this.setPartCenter("legrightback", -0.4f, 0.6f, -1.1f);
        this.setPartCenter("tail", 0.0f, 0.6f, -1.6f);
        this.trophyScale = 0.8f;
        this.trophyOffset = new float[]{0.0f, -0.2f, 0.0f};
    }

    @Override
    public void animatePart(String partName, EntityLiving entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        super.animatePart(partName, entity, time, distance, loop, lookY, lookX, scale);
        float pi = (float)Math.PI;
        float posX = 0.0f;
        float posY = 0.0f;
        float posZ = 0.0f;
        float angleX = 0.0f;
        float angleY = 0.0f;
        float angleZ = 0.0f;
        float rotation = 0.0f;
        float rotX = 0.0f;
        float rotY = 0.0f;
        float rotZ = 0.0f;
        if (partName.equals("mouth")) {
            this.rotate((float)(-Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.1f)) * 0.1f - 0.1f)), 0.0f, 0.0f);
        }
        if (partName.equals("tail")) {
            rotX = (float)(-Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.1f)) * 0.05f - 0.05f));
            rotY = (float)(-Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f)) * 0.05f - 0.05f));
        }
        float walkSwing = 0.3f;
        if (partName.equals("legrightfront") || partName.equals("legleftback")) {
            rotY = (float)((double)rotY + Math.toDegrees(MathHelper.func_76134_b((float)(time * 0.6662f + (float)Math.PI)) * walkSwing * distance));
        }
        if (partName.equals("legleftfront") || partName.equals("legrightback")) {
            rotY = (float)((double)rotY + Math.toDegrees(MathHelper.func_76134_b((float)(time * 0.6662f)) * walkSwing * distance));
        }
        if (entity != null && !entity.field_70122_E && !entity.func_70090_H()) {
            if (partName.equals("legleftback") || partName.equals("legrightback")) {
                rotX += 25.0f;
            }
            if (partName.equals("legleftfront") || partName.equals("legrightfront")) {
                rotX -= 25.0f;
            }
        }
        if (entity instanceof EntityCreatureBase && ((EntityCreatureBase)entity).justAttacked()) {
            if (((EntityCreatureBase)entity).getAttackPhase() % 1 == 0 && partName.equals("legleftfront")) {
                rotX -= 20.0f;
            } else if (((EntityCreatureBase)entity).getAttackPhase() % 2 == 0 && partName.equals("legrightfront")) {
                rotX -= 20.0f;
            }
        }
        this.rotate(rotation, angleX, angleY, angleZ);
        this.rotate(rotX, rotY, rotZ);
        this.translate(posX, posY, posZ);
    }

    @Override
    public void childScale(String partName) {
        if (partName.equals("head") || partName.equals("mouth")) {
            this.translate(-(this.getPartCenter(partName)[0] / 2.0f), -(this.getPartCenter(partName)[1] / 2.0f), -(this.getPartCenter(partName)[2] / 2.0f));
        } else {
            super.childScale(partName);
        }
    }
}

